package de.luschny.struct.bintree;

import javax.swing.*;
import javax.swing.tree.*;

/**
 * Swinging Binary Trees!
 *
 * Eine einfache Utility um binre Bume zu visualisieren.
 *
 * @author Peter Luschny
 * @version 1.0, 2001-01-02
 */

public class BinaryTreeGui
{
    private BinaryTree tree;
    private DefaultMutableTreeNode root;
    private DefaultTreeModel model;
    private JFrame frame;

    /**
     * Die graphische Darstellung eines binren Baums
     * in einem Frame.
     *
     * @param tree der darzustellende Baum.
     * @param frameName der Name der "Baumrahmens".
     */

    public BinaryTreeGui(BinaryTree tree, String frameName)
    {
        this.tree = tree;
        root = new DefaultMutableTreeNode(tree.get(tree.getRoot()));
        model = new DefaultTreeModel(root);
        frame = new JFrame(frameName);

        JScrollPane scroller = new JScrollPane();
        JTree jtree = new JTree(model);
        scroller.getViewport().add(jtree);
        frame.getContentPane().add("Center", scroller);
        frame.setSize(300, 300);
    }

    /**
     * Die einzige ffentliche Methode zeigt die Baumstruktur an.
     */

    public void displayBinaryTree()
    {
        displayNode(tree.getRoot(), root);
        frame.show();
    }

    /**
     * Rekursiver Erzeugung des Baummodells a la Swing.
     *
     * @param bin Knoten des binren Baums
     * @param def Knoten des graphischen Baums
     */

    private void displayNode(BinaryTree.Node bin, DefaultMutableTreeNode def)
    {
        if (bin.isValid())
        {
            BinaryTree.Node lbin = tree.getLeftChild(bin);
            if (lbin.isValid())
            {
                DefaultMutableTreeNode ldef = 
                    new DefaultMutableTreeNode(tree.get(lbin));
                model.insertNodeInto(ldef, def, 0);
                displayNode(lbin, ldef);
            }

            BinaryTree.Node rbin = tree.getRightChild(bin);
            if (rbin.isValid())
            {
                DefaultMutableTreeNode rdef = 
                    new DefaultMutableTreeNode(tree.get(rbin));
                model.insertNodeInto(rdef, def, 1);
                displayNode(rbin, rdef);
            }
        }
    }

}

