import de.luschny.struct.genbintree.GenericBinaryTree;
import de.luschny.struct.genbintree.GenericBinaryTreeTraverse;

/**
 * Beispiel und Test fuer die
 * Klassen GenericBinaryTree und GenericBinaryTreeTraverse
 * Man beachte, dass die Klasse "Object" hier sowenig
 * auftaucht wie irgendwelches Casting.
 * Vergleiche dazu BinaryTreeTest.
 * 
 * @author Peter Luschny
 * @version 1.0, 2001-01-04
 */

public class GenericBinaryTreeTest
{
    /**
     * Teste deinen binren Baum!
     * @param ignore
     */

    static void main(String[] ignore)
    {   // peltuserchny // jagmosesling 
        Character A = new Character('j');
        Character B = new Character('a');
        Character C = new Character('g');
        Character D = new Character('m');
        Character E = new Character('o');
        Character F = new Character('s');
        Character G = new Character('e');
        Character H = new Character('s');
        Character I = new Character('l');
        Character K = new Character('i');
        Character L = new Character('n');
        Character M = new Character('g');

        GenericBinaryTree<Character> tree = 
                        new GenericBinaryTree<Character>();
        GenericBinaryTree<Character>.Node n, nr, nl;

        tree.setRoot(A);

        n = tree.getRoot();
        tree.setLeftChild(B, n);

        nl = tree.getLeftChild(n);
        tree.setRightChild(C, n);

        nr = tree.getRightChild(n);
        tree.setLeftChild(D, nl);

        n = tree.getLeftChild(nl);
        tree.setLeftChild(E, nr);
        tree.setRightChild(F, nr);
        tree.setLeftChild(G, n);
        tree.setRightChild(H, n);

        n = tree.getRightChild(nr);
        tree.setLeftChild(I, n);
        tree.setRightChild(K, n);

        n = tree.getRightChild(n);
        tree.setLeftChild(L, n);
        tree.setRightChild(M, n);

        System.out.println("Beispiel fr binren Baum");
        System.out.println("=========================");

        // Anzahl der Knoten bestimmen
        System.out.print("Anzahl der Knoten:  ");
        System.out.println(tree.size(tree.getRoot()));
        

        // Baum traversieren
        GenericBinaryTreeTraverse<Character> tour = 
                new GenericBinaryTreeTraverse<Character>(tree);
        System.out.print("Baum in Prordnung durchlaufen:    ");
        tour.preOrderTraverse();
        System.out.println();
        System.out.print("Baum in Inordnung durchlaufen:     ");
        tour.inOrderTraverse();
        System.out.println();
        System.out.print("Baum in Postordnung durchlaufen:   ");
        tour.postOrderTraverse();
        System.out.println();
        System.out.print("Baum in Neuordnung durchlaufen:    ");
        tour.peterOrderTraverse();
        System.out.println();

        // So einfach ist das Bearbeiten der Werte
        tour = new GenericBinaryTreeTraverse<Character>(tree)
        {
            // Ueberschreiben der Methode visit in TreeTraverse
            public void visit(Character ch)
            {
                char c = Character.toUpperCase(ch.charValue());
                System.out.print(c + " ");
            }
        };

        System.out.print("Baum zur Bearbeitung durchlaufen:  ");
        tour.preOrderTraverse();
        System.out.println();
        // Lschen und fertig..
        tree.clear();
        System.out.print("Baum gelscht ..");
        tour.postOrderTraverse();  // nichts rhrt sich, also
        System.out.println("..fertig");
    }

}

/*
 * Beispiel fr binren Baum
 * =========================
 * Anzahl der Knoten:  12
 * Baum in Prordnung durchlaufen:   p e t e r l u s c h n y
 * Baum in Inordnung durchlaufen:    e t r e p u l c s n h y
 * Baum in Postordnung durchlaufen:  e r t e u c n y h s l p
 * Baum in Neuordnung durchlaufen:   p l s h y n c u e t r e
 * Baum zur Bearbeitung durchlaufen: P E T E R L U S C H N Y
 * Baum gelscht:
 */

