package de.luschny.struct.genbintree;

/**
 * Die Klasse TreeTraverse stellt einige Standard Methoden
 * zum Durchlaufen eines binaeren Baums zur Verfgung.
 * Man haette natuerlich auf das Idiom des Iterators zurueckgreifen
 * koennen, aber die Traverse (Idiom "Tour" und "Visite")
 * erscheint mir fuer Baeume das "natuerlichere" Konzept zu sein
 * (seit den Zeiten von L.Euler uebrigens).
 * 
 * @author Peter Luschny
 * @version 1.0, 2001-01-04
 */

public class GenericBinaryTreeTraverse<A>
{
    // Der zu durchlaufende Baum.
    private final GenericBinaryTree<A> tree;

    /**
     * Methoden zum Durchlaufen eines binaeren Baumes werden 
     * bereitgestellt.
     * 
     * @param tree der zu durchlaufende Baum
     */

    public GenericBinaryTreeTraverse(GenericBinaryTree<A> tree)
    {
        this.tree = tree;
    }

    /**
     * Traversieren in Praeordnung.
     */

    public void preOrderTraverse()
    {
        preOrder(tree.getRoot());
    }

    /**
     * Traversieren in Inordnung.
     */

    public void inOrderTraverse()
    {
        inOrder(tree.getRoot());
    }

    /**
     * Traversieren in Postordnung.
     */

    public void postOrderTraverse()
    {
        postOrder(tree.getRoot());
    }

    /**
     * Traversieren in Peter's Ordnung ;-).
     */

    public void peterOrderTraverse()
    {
        peterOrder(tree.getRoot());
    }

    /**
     * rekursiv!
     * 
     * @param node, der Elterknoten.
     */

    private void preOrder(GenericBinaryTree<A>.Node parent)
    {
        if (parent.isValid())
        {
            visit(tree.get(parent));
            preOrder(tree.getLeftChild(parent));
            preOrder(tree.getRightChild(parent));
        }
    }

    /**
     * rekursiv!
     * 
     * @param node
     */

    private void inOrder(GenericBinaryTree<A>.Node parent)
    {
        if (parent.isValid())
        {
            inOrder(tree.getLeftChild(parent));
            visit(tree.get(parent));
            inOrder(tree.getRightChild(parent));
        }
    }

    /**
     * rekursiv!
     * 
     * @param node, der Elterknoten.
     */

    private void postOrder(GenericBinaryTree<A>.Node parent)
    {
        if (parent.isValid())
        {
            postOrder(tree.getLeftChild(parent));
            postOrder(tree.getRightChild(parent));
            visit(tree.get(parent));
        }
    }

    /**
     * rekursiv!
     * 
     * @param node, der Elterknoten
     */

    private void peterOrder(GenericBinaryTree<A>.Node parent)
    {
        if (parent.isValid())
        {
            visit(tree.get(parent));
            peterOrder(tree.getRightChild(parent));
            peterOrder(tree.getLeftChild(parent));
        }
    }

    /**
     * Anreichung des Wertes eines Baumknotens whrend der Traverse.
     * Hier System.out.print(value.toString()) implementiert.
     * Zum Ueberschreiben durch eine Bearbeitungsfunktion vorgesehen.
     * 
     * @param value Wert (des zu bearbeitenden) Baumknotens
     */

    protected void visit(A value)
    {
        System.out.print(value.toString() + " ");
    }

}

