/*
 * Decompiled with CFR 0.152.
 */
package de.luschny.math.ruler;

import java.io.PrintWriter;
import java.util.NoSuchElementException;

class PerfectRuler {
    private static int[] perfCount = new int[]{1, 1, 1, 2, 3, 4, 2, 12, 8, 4, 38, 30, 14, 6, 130, 80, 32, 12, 500, 326, 150, 66, 18, 4, 944, 460, 166, 56, 12, 6, 2036, 890, 304, 120, 20, 10, 2, 2678, 974, 362, 100, 36, 4, 2, 4892, 2114, 684, 238, 68, 22, 4, 16318, 6350, 2286, 836, 330, 108, 24, 12, 31980, 12252, 4960, 1806, 668, 238, 86, 6, 12, 4, 15558, 5906, 2558, 850, 388, 120, 38, 4, 6, 4, 2, 4972, 2234, 798, 332, 106, 48, 4, 6, 2, 2, 2, 3392, 1262, 626, 212, 76, 40, 16, 2, 2, 2, 2, 3426, 1506, 682, 360, 138, 70, 28, 8, 2, 2, 2, 6578, 2984, 1458, 586, 374, 192, 98, 38, 14, 4, 4};
    private PrintWriter file;
    private int[][] rulers;
    private int[] r;
    private int L1;
    private int count;
    private int maxCount;
    private int perCount;
    private boolean[] option;

    public PerfectRuler(PrintWriter report, boolean[] opt) {
        this.file = report;
        this.option = opt;
        this.rulers = new int[16000][];
    }

    public int ruler(int M, int L) {
        this.perCount = L < perfCount.length ? perfCount[L] : 32000;
        int n = this.maxCount = this.option[1] ? 1 : this.perCount;
        if (this.option[0]) {
            this.file.println("Number of rulers(" + (M - 1) + "," + L + ") = " + this.maxCount);
            return this.maxCount;
        }
        this.maxCount = this.maxCount + (this.maxCount | 1) >> 1;
        int S = M * (M - 1) / 2;
        this.L1 = L + 1;
        this.r = new int[M + 1];
        int[] R = new int[S + 1];
        int[] K = new int[M + 2];
        K[2] = L;
        K[3] = 1;
        R[1] = 1;
        R[L] = 1;
        R[L - 1] = 1;
        this.file.println();
        this.file.println("Rulers(" + (M - 1) + "," + L + ") List of rulers:");
        this.file.println();
        this.count = 0;
        try {
            this.generator(M, L, K, R, 3, S, 1, false);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        if (this.option[1]) {
            this.count = 1;
        } else {
            this.count = L < perfCount.length ? this.perCount : 2 * this.count;
            this.file.print("Rulers(" + (M - 1) + "," + L + ") ");
            this.file.println("Number of rulers: " + this.count);
        }
        this.file.flush();
        return this.count;
    }

    private void generator(int M, int L, int[] K, int[] R, int i, int S, int w, boolean b) {
        if (i < M) {
            int k = w;
            while (R[L - k] > 0) {
                ++k;
            }
            int t = L - M + i + 1;
            if ((t & 1) == 1) {
                ++t;
            }
            if ((t >>= 1) < k) {
                k = t;
            }
            while (k > w) {
                this.expander(M, L, K, R, i + 1, S, k, true);
                this.expander(M, L, K, R, i + 1, S, k, false);
                --k;
            }
            if (!b) {
                this.expander(M, L, K, R, i + 1, S, w, true);
            }
        } else {
            this.checker(M, K);
        }
    }

    private void expander(int M, int L, int[] K, int[] R, int i, int S, int w, boolean b) {
        int len;
        int j;
        int ka;
        K[i] = ka = b ? L - w : w;
        for (j = 1; j < i; ++j) {
            len = ka - K[j];
            if (len < 0) {
                len = -len;
            }
            if (R[len] > 0) {
                --S;
            }
            int n = len;
            R[n] = R[n] + 1;
        }
        if (S >= L) {
            this.generator(M, L, K, R, i, S, w, b);
        }
        for (j = 1; j < i; ++j) {
            len = ka - K[j];
            if (len < 0) {
                len = -len;
            }
            int n = len;
            R[n] = R[n] - 1;
        }
    }

    private void checker(int M, int[] K) {
        int k;
        int i;
        int[] a = this.r;
        a[1] = K[1];
        a[M] = K[2];
        for (i = 3; i <= M; ++i) {
            int j = i - 1;
            while (K[i] < a[j - 1]) {
                a[j] = a[j - 1];
                --j;
            }
            a[j] = K[i];
        }
        int[] rul = new int[M - 1];
        for (k = 1; k < M; ++k) {
            int d = a[k + 1] - a[k];
            if (d <= 0) {
                return;
            }
            rul[k - 1] = d;
        }
        int M2 = M - 2;
        for (k = 0; k < M - 1 && rul[k] >= rul[M2 - k]; ++k) {
            if (rul[k] == rul[M2 - k]) continue;
            for (int j = M2 - 1 >> 1; j >= 0; --j) {
                int temp = rul[j];
                rul[j] = rul[M2 - j];
                rul[M2 - j] = temp;
            }
            break;
        }
        for (i = this.count - 1; i >= 0; --i) {
            int[] rulI = this.rulers[i];
            for (k = M2; k >= 0 && rul[k] == rulI[k]; --k) {
            }
            if (k >= 0) continue;
            return;
        }
        this.rulers[this.count++] = rul;
        this.printer(a);
        if (this.maxCount <= this.count) {
            throw new NoSuchElementException();
        }
    }

    private void printer(int[] a) {
        int nop = 0;
        if (this.option[0]) {
            return;
        }
        if (this.option[4]) {
            ++nop;
            this.printSymbolic(a);
        }
        if (this.option[2]) {
            ++nop;
            this.printRuler(a);
        }
        if (this.option[3]) {
            ++nop;
            this.printDiffRepresentation(a);
        }
        if (this.option[6]) {
            ++nop;
            this.printTypeOf(a);
        }
        if (this.option[5]) {
            ++nop;
            this.printDiffTable(a);
        }
        if (nop > 1) {
            this.file.println();
        }
    }

    private void printRuler(int[] a) {
        this.file.print("[0");
        for (int i = 2; i < a.length; ++i) {
            this.file.print(",");
            this.file.print(a[i]);
        }
        this.file.println("]");
    }

    private void printSymbolic(int[] a) {
        StringBuilder sr = new StringBuilder(this.L1);
        int l = 0;
        for (int i = 1; i < a.length; ++i) {
            while (l++ < a[i]) {
                sr.append('-');
            }
            sr.append('|');
        }
        this.file.println(sr.toString());
    }

    private void printDiffRepresentation(int[] a) {
        this.file.print("<" + (a[2] - a[1]));
        for (int i = 2; i < a.length - 1; ++i) {
            int w = a[i + 1] - a[i];
            this.file.print(",");
            this.file.print(w);
        }
        this.file.println(">");
    }

    private void printDiffTable(int[] a) {
        for (int i = a.length - 1; i > 0; --i) {
            for (int j = 1; j < i; ++j) {
                int w = a[i] - a[i - j];
                this.file.print(w);
                this.file.print(",");
            }
            this.file.println();
        }
    }

    private int[] typeOf(int[] a) {
        int[] t = new int[this.L1];
        for (int i = a.length - 1; i > 0; --i) {
            for (int j = 1; j < i; ++j) {
                int d = a[i] - a[i - j];
                t[d] = t[d] + 1;
            }
        }
        return t;
    }

    private void printTypeOf(int[] a) {
        int[] t = this.typeOf(a);
        this.file.print("|");
        if (t.length < 8) {
            for (int i = 1; i < t.length; ++i) {
                this.file.print(i + "^" + t[i] + "|");
            }
        } else {
            for (int i = 1; i < t.length; ++i) {
                if (t[i] <= 1) continue;
                this.file.print(i + "^" + t[i] + "|");
            }
        }
        this.file.println();
    }
}

