/*
 * Decompiled with CFR 0.152.
 */
package de.luschny.math.ruler;

import de.luschny.math.ruler.Rulez;

public class Ruler {
    static String[] help = new String[]{"    PURPOSE OF THE PROGRAM", "    Generating all perfect or optimal rulers of given length.", "", "      A ruler with length L is 'perfect' if", "  (a) the ruler is complete, i.e. all distances d with", "      1 <= d <= L can be measured with the ruler and", "  (b) there is no complete ruler with the same length which", "      possesses fewer marks. If, in addition,", "  (c) there is no complete ruler with the same number of marks", "      which has a greater length, then the ruler is 'optimal'.", "", "    SYNTAX:  \"function(from, to, options)\" ", "             (Like a function call with three arguments.)", "", "    function is one out of { perfect, optimal, single }", "", "    perfect -> generate all perfect rulers with length L", "               constrained by 1 <= from <= L <= to <= 101", "    single  -> generate only one perfect ruler with length L", "               constrained by 1 <= from <= L <= to <= 112", "    optimal -> generate all optimal rulers with S segments", "               constrained by 1 <= from <= S <= to <= 16", "", "   'options' are any substrings of \"cmdbtf\".", "", "   c : count rulers only, don't print them", "       for example: Rulers(8,23), Number of rulers: 4", "   m : generate and print the marker-representation", "       for example: [0,1,4,10,16,18,21,23]", "   d : generate and print the difference representation", "       for example: <1,3,6,6,2,3,2>", "   b : generate and print the binary representation", "       for example ||--|-----|-----|-|--|-|", "   t : generate and print the type of the ruler", "       for example |1^3|2^3|3^3|7^3|14^3|21^3|", "   f : generate and print the difference-triangle", "", "   All the above options can be combined in a single string.", "   The option 'c' overrides all other options.", "", "   EXAMPLE USAGE: perfect(23,44,mdb), single(1,80,b)", "                  optimal(1,20,c), optimal(12,12,mdbtf)", "", "   **********************************************************", "   Note:  If two different rulers are mirror-symmetric both", "          will be counted, but only one will be represented.", "          For example: [0,1,3] is mirror-symmetric to [0,2,3].", "   ***********************************************************", "", "   File:  Rulers will be saved to the file 'rulers.txt'.", "   Info:  http://www.luschny.de/math/rulers/index.html"};

    public static void main(String[] args) {
        String fileName = "ruler.txt";
        if (args.length == 1) {
            Ruler.run(args[0], fileName);
        } else {
            Ruler.run("noparam", fileName);
        }
    }

    static void run(String arg, String fileName) {
        boolean validParams;
        boolean bl = validParams = !arg.equalsIgnoreCase("noparam");
        if (validParams) {
            System.out.println("FunctionCall: " + arg);
            Rulez ruler = new Rulez(fileName);
            validParams = ruler.compute(arg);
        }
        if (!validParams) {
            System.out.println(" *** Missing or invalid arguments ***");
            System.out.println();
            for (int i = 0; i < help.length; ++i) {
                System.out.println(help[i]);
            }
            return;
        }
        System.out.println("Saved to file: " + fileName);
    }
}

