/*
 * Decompiled with CFR 0.152.
 */
package de.luschny.math.ruler;

import de.luschny.math.ruler.PerfectRuler;
import de.luschny.math.ruler.StopWatch;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;

class Rulez {
    static int[] optIndex = new int[]{1, 1, 3, 6, 9, 13, 17, 23, 29, 36, 43, 50, 58, 68, 79, 90, 101, 112, 123};
    static int[] lenToSegment = new int[]{1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19};
    static final int countOnly = 0;
    static final int singleOnly = 1;
    static final int markerRep = 2;
    static final int diffRep = 3;
    static final int symbolicRep = 4;
    static final int tableRep = 5;
    static final int typeRep = 6;
    static boolean[] option = new boolean[]{false, false, false, false, false, false, false};
    static int function;
    static int From;
    static int To;
    static final int perfect = 0;
    static final int optimal = 1;
    static final int single = 2;
    static String[] functionName;
    PerfectRuler generator;
    StopWatch watch;
    StopWatch mwatch;
    StopWatch mainWatch = new StopWatch();
    PrintWriter rulerReport;

    static boolean validArgs(String args) {
        args = args.replace('(', ',');
        args = args.replace(')', ',');
        Scanner sc = new Scanner(args).useDelimiter(",");
        try {
            String fun = sc.next();
            int inFrom = sc.nextInt();
            int inTo = sc.nextInt();
            String opt = sc.next();
            sc.close();
            if (fun.equalsIgnoreCase(functionName[0])) {
                function = 0;
            } else if (fun.equalsIgnoreCase(functionName[1])) {
                function = 1;
            } else if (fun.equalsIgnoreCase(functionName[2])) {
                function = 2;
            } else {
                throw new IllegalArgumentException("Function name invalid!");
            }
            Rulez.option[0] = opt.contains("c");
            if (!option[0]) {
                boolean optset = false;
                Rulez.option[2] = opt.contains("m");
                optset |= Rulez.option[2];
                Rulez.option[3] = opt.contains("d");
                optset |= Rulez.option[3];
                Rulez.option[4] = opt.contains("b");
                optset |= Rulez.option[4];
                Rulez.option[6] = opt.contains("t");
                optset |= Rulez.option[6];
                Rulez.option[5] = opt.contains("f");
                if (!(optset |= Rulez.option[5])) {
                    throw new IllegalArgumentException("Options missing!");
                }
            }
            Rulez.option[1] = function == 2;
            int lmin = 1;
            int lmax = function == 1 ? 999 : (function == 0 ? 999 : 999);
            From = Math.min(Math.max(lmin, inFrom), lmax);
            To = Math.max(lmin, Math.min(inTo, lmax));
        }
        catch (Exception e) {
            System.out.println(e.toString());
            return false;
        }
        return true;
    }

    public Rulez(String fileName) {
        this.watch = new StopWatch();
        this.mwatch = new StopWatch();
        try {
            this.rulerReport = new PrintWriter(new BufferedWriter(new FileWriter(fileName, true)));
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return;
        }
        this.generator = new PerfectRuler(this.rulerReport, option);
    }

    public boolean compute(String args) {
        if (!Rulez.validArgs(args)) {
            return false;
        }
        System.out.println("Computing " + functionName[function] + " rulers from " + From + " to " + To + ".");
        this.mainWatch.start();
        int count = this.handler(function, From, To, option);
        this.mainWatch.stop();
        System.out.println(count + " rulers");
        if (!option[0]) {
            System.out.println("Generated in " + this.mainWatch.toString());
        }
        this.rulerReport.flush();
        return true;
    }

    int handler(int fun, int from, int to, boolean[] options) {
        int allcount = 0;
        int markcount = 0;
        int segment = lenToSegment[from];
        for (int i = from; i <= to; ++i) {
            int L;
            int S = fun == 1 ? i : lenToSegment[i];
            int n = L = fun == 1 ? optIndex[i] : i;
            if (segment != S && fun != 1) {
                this.mwatch.stop();
                System.out.print("* S=" + segment + "  -> " + markcount);
                System.out.println(" in " + this.mwatch.toString());
                this.mwatch.restart();
                markcount = 0;
                segment = S;
            }
            this.watch.restart();
            int count = this.generator.ruler(S + 1, L);
            this.watch.stop();
            allcount += count;
            markcount += count;
            System.out.print("(" + S + "," + L + ") -> " + count);
            System.out.println(" in " + this.watch.toString());
        }
        if (fun != 1) {
            this.mwatch.stop();
            System.out.print("* S=" + segment + "  -> " + markcount);
            System.out.println(" in " + this.mwatch.toString());
        }
        return allcount;
    }

    static {
        functionName = new String[]{"perfect", "optimal", "single"};
    }
}

